import time
import board
import pwmio
import digitalio

# L293D lábkiosztás – ESP32-C3 IO0, IO1, IO2
PWMA = board.IO0   # Enable1 -> PWM
D1A  = board.IO1   # Input1
D2A  = board.IO2   # Input2

# PWM kimenet létrehozása
pwm = pwmio.PWMOut(PWMA, frequency=1000, duty_cycle=0)

# Digitális kimenetek létrehozása
d1 = digitalio.DigitalInOut(D1A)
d1.direction = digitalio.Direction.OUTPUT

d2 = digitalio.DigitalInOut(D2A)
d2.direction = digitalio.Direction.OUTPUT

def set_motor(speed_percent, reverse):
    """
    speed_percent: 0–100 közötti érték (sebesség százalékban)
    reverse: True = hátra, False = előre
    """
    # Skálázás 16 bites duty cycle-re
    duty = int((speed_percent / 100.0) * 65535)
    pwm.duty_cycle = duty
    d1.value = not reverse
    d2.value = reverse

print("\nL293D test program (ESP32-C3, CircuitPython)")

while True:
    time.sleep(5)
    print("----------------")
    print("move forward 75%")
    set_motor(75, False)   # előre 75%
    time.sleep(2)
    set_motor(0, False)    # stop
    time.sleep(1)
    print("move reverse 75%")
    set_motor(75, True)    # hátra 75%
    time.sleep(2)
    set_motor(0, True)     # stop
