/** L293D_test_1M
 *  Demo program to drive one motor forward and backward
 *  by using a L293D motor controller IC. 
 */
#define PWMA   3                 //L293D pin1  Enable1
#define D1A    2                 //L293D pin2  Input1
#define D2A    4                 //L293D pin7  Input2

void setMotor(int speed, boolean reverse) {
  analogWrite(PWMA, speed);
  digitalWrite(D1A, ! reverse);
  digitalWrite(D2A, reverse);
}


void setup() {
  Serial.begin(9600);  
  pinMode(PWMA, OUTPUT);  
  pinMode(D1A, OUTPUT);
  pinMode(D2A, OUTPUT);
  Serial.println("\r\nL293D test program");
}


void loop() {
  delay(5000);
  Serial.println("move forward 75%");
  setMotor(196, 0);               // Forward speed = 75%
  delay(2000);
  setMotor(0, 0);                 // Stop motor 
  delay(1000);   
  Serial.println("move reverse 75%");
  setMotor(196, 1);               // Reverse speed = 75%
  delay(2000);  
  setMotor(0, 0);                 // Stop motor    
}


