import time, board, pwmio, digitalio

# --- L293D lábkiosztás az ESP32-C3-on --
PWMA = board.IO0    # L293D pin1
D1A  = board.IO1    # L293D pin2
D2A  = board.IO2    # L293D pin7
PWMB = board.IO21   # L293D pin9
D3B  = board.IO20   # L293D pin10
D4B  = board.IO10   # L293D pin15

# --- PWM inicializálás 1000 Hz frekvenciával --
pwmA = pwmio.PWMOut(PWMA, frequency=1000, duty_cycle=0)
pwmB = pwmio.PWMOut(PWMB, frequency=1000, duty_cycle=0)

# --- Digitális irányvezérlő lábak --
d1a = digitalio.DigitalInOut(D1A)
d1a.direction = digitalio.Direction.OUTPUT
d2a = digitalio.DigitalInOut(D2A)
d2a.direction = digitalio.Direction.OUTPUT
d3b = digitalio.DigitalInOut(D3B)
d3b.direction = digitalio.Direction.OUTPUT
d4b = digitalio.DigitalInOut(D4B)
d4b.direction = digitalio.Direction.OUTPUT

def set_motor(speed: int, reverse: bool):
""" speed: 0–100 közötti érték (százalék)
    reverse: True = hátramenet, False = előremenet   """
    # Skálázás 16 bites duty_cycle értékre (0–65535)
    duty = int((speed / 100.0) * 65535)
    pwmA.duty_cycle = duty
    pwmB.duty_cycle = duty
    d1a.value = not reverse
    d2a.value = reverse
    d3b.value = not reverse
    d4b.value = reverse

# --- Főprogram --
print("\nL293D test 2M program (CircuitPython, ESP32-C3)")
while True:
    time.sleep(5)
    print("move forward 75%")
    set_motor(75, False)   # előre 75%
    time.sleep(2)
    set_motor(0, False)    # stop
    time.sleep(1)
    print("move reverse 75%")
    set_motor(75, True)    # hátra 75%
    time.sleep(2)
    set_motor(0, False)    # stop