/** L293D_test_2M
 *  Demo program to drive two motor forward and backward
 *  by using a L293D motor controller IC. 
 */
#define PWMA   3    //L293D pin1
#define D1A    2    //L293D pin2
#define D2A    4    //L293D pin7
#define PWMB   6    //L293D pin9
#define D3B    5    //L293D pin10
#define D4B    7    //L293D pin15


void setMotor(int speed, boolean reverse) {
  analogWrite(PWMA, speed);
  digitalWrite(D1A, !reverse);
  digitalWrite(D2A, reverse);
  analogWrite(PWMB, speed);
  digitalWrite(D3B, !reverse);
  digitalWrite(D4B, reverse);  
}


void setup() {
  Serial.begin(9600);  
  pinMode(PWMA, OUTPUT);  
  pinMode(D1A, OUTPUT);
  pinMode(D2A, OUTPUT);
  pinMode(PWMB, OUTPUT);  
  pinMode(D3B, OUTPUT);
  pinMode(D4B, OUTPUT);  
  Serial.println("\r\nL293D test program");
}


void loop() {
  delay(5000);
  Serial.println("move forward 75%");
  setMotor(196, 0);               // Forward speed = 75%
  delay(2000);
  setMotor(0, 0);                 // Stop motor 
  delay(1000);   
  Serial.println("move reverse 75%");
  setMotor(196, 1);               // Reverse speed = 75%
  delay(2000);  
  setMotor(0, 0);                 // Stop motor    
}


