import time
import board
import digitalio
# --- L298N lábkiosztás az ESP32-C3-on --
B1A = board.IO3   # Bal motor előre
B1B = board.IO2   # Bal motor hátra
A1A = board.IO1   # Jobb motor előre
A1B = board.IO0   # Jobb motor hátra
# --- Digitális kimenetek inicializálása --
b1a = digitalio.DigitalInOut(B1A)
b1a.direction = digitalio.Direction.OUTPUT
b1b = digitalio.DigitalInOut(B1B)
b1b.direction = digitalio.Direction.OUTPUT
a1a = digitalio.DigitalInOut(A1A)
a1a.direction = digitalio.Direction.OUTPUT
a1b = digitalio.DigitalInOut(A1B)
a1b.direction = digitalio.Direction.OUTPUT
# --- Kezdeti állapot: minden motor kikapcsolva --
b1a.value = False
b1b.value = False
a1a.value = False
a1b.value = False
print("Motor test (CircuitPython, ESP32-C3)")

while True:
    print("Forward ALL")
    b1a.value = True
    b1b.value = False
    a1a.value = True
    a1b.value = False
    time.sleep(3)
    b1a.value = False
    b1b.value = False
    a1a.value = False
    a1b.value = False
    time.sleep(1)
    print("Reverse ALL")
    b1a.value = False
    b1b.value = True
    a1a.value = False
    a1b.value = True
    time.sleep(3)
    b1a.value = False
    b1b.value = False
    a1a.value = False
    a1b.value = False
    time.sleep(1) 
    print("Turn RIGHT")
    b1a.value = True
    b1b.value = False
    a1a.value = False
    a1b.value = False
    time.sleep(3)
    b1a.value = False
    b1b.value = False
    a1a.value = False
    a1b.value = False
    time.sleep(1)
    print("Turn LEFT")
    b1a.value = False
    b1b.value = False
    a1a.value = True
    a1b.value = False
    time.sleep(3)
    b1a.value = False
    b1b.value = False
    a1a.value = False
    a1b.value = False
    time.sleep(2) 
