import board
import busio
import adafruit_sh1106

# Create the I2C interface.
i2c = busio.I2C(board.SCL, board.SDA, frequency=400000)

# Create the SH1106 OLED class.
# The first two parameters are the pixel width and pixel height.  Change these
# to the right size for your display!
oled = adafruit_sh1106.SH1106_I2C(128, 64, i2c, addr=0x3c, external_vcc=False)


# initial center of the circle
center_x = 63
center_y = 15
# how fast does it move in each direction
x_inc = 2
y_inc = 2
# what is the starting radius of the circle
radius = 8

# start with a blank screen
oled.fill(0)
# we just blanked the framebuffer. to push the framebuffer onto the display, we call show()
oled.show()
while True:
    # undraw the previous circle
    oled.circle(center_x, center_y, radius, 0)

    # if bouncing off right
    if center_x + radius >= oled.width-1:
        # start moving to the left
        x_inc = -2
    # if bouncing off left
    elif center_x - radius < 1:
        # start moving to the right
        x_inc = 2

    # if bouncing off top
    if center_y + radius >= oled.height-1:
        # start moving down
        y_inc = -2
    # if bouncing off bottom
    elif center_y - radius < 1:
        # start moving up
        y_inc = 2

    # go more in the current direction
    center_x += x_inc
    center_y += y_inc

    # draw the new circle
    oled.circle(center_x, center_y, radius,1)
    # show all the changes we just made
    oled.show()