# SPDX-FileCopyrightText: 2021 ladyada for Adafruit Industries
# SPDX-License-Identifier: MIT

"""
SH1106 OLED kijelző tesztprogram (az Adafruit ssd1306_displayio_test.py
program adaptációja SH1106 kijelzőre. Adaptáció: I. Cserny).
Tesztelve: ESP32-C3 mikrokontroller + CircuitPython 10.0.2 firmware.

A program inicializálja az SH1106 kijelzőt displayio segítségével,
majd megjelenít egy fehér hátteret, egy belső fekete téglalapot,
és egy fehér színű szöveget.
"""

import board
import displayio
import terminalio
from adafruit_display_text import label
from i2cdisplaybus import I2CDisplayBus
import adafruit_displayio_sh1106  # közösségi driver kell a lib mappába

displayio.release_displays()

# I2C inicializálás
i2c = board.I2C()  # board.SCL és board.SDA lábak használata
display_bus = I2CDisplayBus(i2c, device_address=0x3C)

# SH1106 paraméterek
WIDTH = 128   # teljes fizikai szélesség
HEIGHT = 64
BORDER = 5

# colstart=2 → X irányú eltolás
display = adafruit_displayio_sh1106.SH1106(display_bus, width=WIDTH+4, height=HEIGHT, colstart=2)

# Megjelenítési kontextus
splash = displayio.Group()
display.root_group = splash

# Háttér bitmap (fehér)
color_bitmap = displayio.Bitmap(WIDTH, HEIGHT, 1)
color_palette = displayio.Palette(1)
color_palette[0] = 0xFFFFFF
bg_sprite = displayio.TileGrid(color_bitmap, pixel_shader=color_palette, x=0, y=0)
splash.append(bg_sprite)

# Belső fekete téglalap
inner_bitmap = displayio.Bitmap(WIDTH - BORDER * 2, HEIGHT - BORDER * 2, 1)
inner_palette = displayio.Palette(1)
inner_palette[0] = 0x000000
inner_sprite = displayio.TileGrid(inner_bitmap, pixel_shader=inner_palette, x=BORDER, y=BORDER)
splash.append(inner_sprite)

# Szöveg megjelenítése
text = "   CircuitPython\n     tanfolyam\n Hobbielektronika"
text_area = label.Label(terminalio.FONT, text=text, color=0xFFFFFF, x=10, y=15)
splash.append(text_area)

while True:
    pass
