"""
SH1106 OLED kijelző tesztprogram (framebuffer változat).
Tesztelve: ESP32-C3 mikrokontroller + CircuitPython 10.0.2 firmware.

A program inicializálja az SH1106 kijelzőt I2C interfészen keresztül,
majd egyszerű grafikus primitívek segítségével kirajzolja a "VOX" feliratot.
A végén demonstrálja a kontraszt- és invertálás funkciókat.
"""

import board
import busio
import adafruit_sh1106 # Ez az általunk adaptált könyvtár
import time

# I2C interfész létrehozása (400 kHz frekvenciával)
i2c = busio.I2C(board.SCL, board.SDA, frequency=400000)

# SH1106 OLED osztály példányosítása (128x64 felbontás, cím: 0x3C)
oled = adafruit_sh1106.SH1106_I2C(128, 64, i2c, addr=0x3c, external_vcc=False)

# Kijelző beállítások és törlés
oled.rotate(0)        # kijelző orientáció (0 = alaphelyzet)
oled.fill(0)          # teljes kijelző törlése (fekete háttér)

# "V" betű kirajzolása vonalakkal
oled.line(0, 0, 10, 31, 1)
oled.line(10, 31, 21, 0, 1)

# "X" betű kirajzolása vonalakkal
oled.line(100, 0, 120, 31, 1)
oled.line(100, 31, 120, 0, 1)

# "O" betű kirajzolása körrel
oled.circle(54, 32, 30, 1)

# Keret rajzolása a kijelző szélére
oled.rect(0, 0, 128, 64, 1)

# Kijelző frissítése
oled.show()

# Végtelen ciklus: kontraszt és invertálás demonstrációja
while True:
    oled.contrast(0x60)   # kontraszt beállítása alacsonyabb értékre
    time.sleep(2)
    oled.invert(1)        # kijelző invertálása (fekete-fehér felcserélve)
    time.sleep(2)
    oled.invert(0)        # visszaállítás normál módra
    time.sleep(2)
    oled.contrast(0x90)   # kontraszt beállítása magasabb értékre
    time.sleep(2)
