# SPDX-FileCopyrightText: 2026 I. Cserny
# SPDX-License-Identifier: MIT
#
# ESP32-C3 + ST7735R display test (landscape mode)
# Loads and displays a 160x128 BMP file: bitmap_demo.bmp

import board
import displayio
from fourwire import FourWire
from adafruit_st7735r import ST7735R

# Release any previous display resources
displayio.release_displays()

# ------------------------------------------------------------
# ST7735 to ESP32-C3 pin mapping:
# SCK  -> IO4
# SDA  -> IO6
# CS   -> IO7
# A0   -> IO3
# RST  -> IO2
# ------------------------------------------------------------

spi = board.SPI()          # uses IO4 (SCK) and IO6 (MOSI) automatically
tft_cs = board.IO7
tft_dc = board.IO3
tft_rst = board.IO2

# Create the 4-wire SPI display bus
display_bus = FourWire(
    spi,
    command=tft_dc,
    chip_select=tft_cs,
    reset=tft_rst
)

# ------------------------------------------------------------
# ST7735R display setup
# Landscape mode → rotation = 90 (or 270 depending on orientation)
# Full resolution: 160x128 pixels
# ------------------------------------------------------------
display = ST7735R(
    display_bus,
    width=160,
    height=128,
    rotation=90,   # rotation angle
    bgr=True
)

# Root display group
splash = displayio.Group()
display.root_group = splash

# ------------------------------------------------------------
# Load and display the full-screen BMP image
# The BMP must be:
# - 160x128 pixels
# - uncompressed Windows BMP (16-bit or 24-bit)
# ------------------------------------------------------------
bitmap = displayio.OnDiskBitmap("bitmap_demo.bmp")

tile_grid = displayio.TileGrid(
    bitmap,
    pixel_shader=getattr(bitmap, "pixel_shader", None),
    x=0,
    y=0
)

splash.append(tile_grid)

# ------------------------------------------------------------
# Main loop (do nothing)
# ------------------------------------------------------------
while True:
    pass

