# SPDX-FileCopyrightText: 2026 I. Cserny
# SPDX-License-Identifier: MIT
#
# ESP32-C3 + ST7735R display test (Portrait mode)
# Loads and displays a 128x160 BMP file using Adafruit imageload

import board
import displayio
from fourwire import FourWire
from adafruit_st7735r import ST7735R
from adafruit_imageload import load

# Release any previous display resources
displayio.release_displays()

# ------------------------------------------------------------
# ST7735 to ESP32-C3 pin mapping:
# SCK  -> IO4
# SDA  -> IO6
# CS   -> IO7
# A0   -> IO3
# RST  -> IO2
# ------------------------------------------------------------

spi = board.SPI()          # uses IO4 (SCK) and IO6 (MOSI) automatically
tft_cs = board.IO7
tft_dc = board.IO3
tft_rst = board.IO2

# Create the 4-wire SPI display bus
display_bus = FourWire(
    spi,
    command=tft_dc,
    chip_select=tft_cs,
    reset=tft_rst
)

# ------------------------------------------------------------
# ST7735R display setup
# Portrait mode → rotation = 90 (or 180 depending on orientation)
# Full resolution: 128x160 pixels
# ------------------------------------------------------------
display = ST7735R(
    display_bus,
    width=128,
    height=160,
    rotation=0,    # rotation angle
    bgr=True
)

# Root display group
splash = displayio.Group()
display.root_group = splash

# ------------------------------------------------------------
# Load and display the full-screen BMP image (using imageload)
# The BMP must be:
# - 128x160 pixels
# - uncompressed Windows BMP
# ------------------------------------------------------------
bitmap, palette = load("buek.jpg")

tile_grid = displayio.TileGrid(
    bitmap,
    pixel_shader=palette,
    x=0,
    y=0
)

splash.append(tile_grid)

# ------------------------------------------------------------
# Main loop (do nothing)
# ------------------------------------------------------------
while True:
    pass
