"""
Simple slideshow example. The images should be BMP files placed into the /images directory.
"""
import board
import displayio
import time
from fourwire import FourWire
from adafruit_st7735r import ST7735R
from adafruit_slideshow import PlayBackOrder, SlideShow

# Release any resources currently in use for the displays
displayio.release_displays()

# create the spi device and pins we will need
spi = board.SPI()
display_bus = FourWire(spi, command=board.IO3, chip_select=board.IO7, reset=board.IO2)
display = ST7735R(display_bus, width=128, height=160, rotation=0, bgr=True) # Portrait mode

# Create the slideshow object that plays through once alphabetically.
slideshow = SlideShow(display,
                      folder="/images",
                      loop=True,
                      order=PlayBackOrder.ALPHABETICAL,
                      dwell=5)

while slideshow.update():
    pass