# SPDX-FileCopyrightText: 2021 ladyada for Adafruit Industries
# SPDX-License-Identifier: MIT

# Based on the Adafruit example: st7735r_128x160_colored_labels.py
# Original code © Adafruit Industries.
#
# Modifications by I. Cserny, 2026:
# - Adapted for ESP32-C3 microcontroller
# - Changed display initialization to portrait orientation
#
# This test will initialize the display using displayio and draw 8 colored
# labels. Useful for testing the color settings on an unknown display.


import board
import displayio
import terminalio
from adafruit_display_text import label
from fourwire import FourWire
from adafruit_st7735r import ST7735R

# Release any resources currently in use for the displays
displayio.release_displays()

spi = board.SPI()
tft_cs = board.IO7
tft_dc = board.IO3

display_bus = FourWire(spi, command=tft_dc, chip_select=tft_cs, reset=board.IO2)
display = ST7735R(display_bus, width=128, height=160, rotation=0, bgr=True)

# Make the display context
splash = displayio.Group()
display.root_group = splash

"""
# This section can draw a colored background
color_bitmap = displayio.Bitmap(128, 80, 1)
color_palette = displayio.Palette(1)
# write some text in each font color, rgb, cmyk
color_palette[0] = 0x111111  # light grey
bg = displayio.TileGrid(color_bitmap, pixel_shader=color_palette, x=0, y=0)
splash.append(bg)
"""


# write some text in each font color, rgb, cmyk
# Left column: RGBW
text_group_left = displayio.Group(x=10, y=20)
text_area_red = label.Label(terminalio.FONT, text="RED", color=0xFF0000, x=0, y=0)
text_group_left.append(text_area_red)
text_area_green = label.Label(terminalio.FONT, text="GREEN", color=0x00FF00, x=0, y=12)
text_group_left.append(text_area_green)
text_area_blue = label.Label(terminalio.FONT, text="BLUE", color=0x0000FF, x=0, y=24)
text_group_left.append(text_area_blue)
text_area_white = label.Label(terminalio.FONT, text="WHITE", color=0xFFFFFF, x=0, y=36)
text_group_left.append(text_area_white)
splash.append(text_group_left)


# Right column: CMYK + Grey
text_group_right = displayio.Group(x=74, y=20)
text_area_cyan = label.Label(terminalio.FONT, text="CYAN", color=0x00FFFF, x=0, y=0)
text_group_right.append(text_area_cyan)
text_area_magenta = label.Label(terminalio.FONT, text="MAGENTA", color=0xFF00FF, x=0, y=12)
text_group_right.append(text_area_magenta)
text_area_yellow = label.Label(terminalio.FONT, text="YELLOW", color=0xFFFF00, x=0, y=24)
text_group_right.append(text_area_yellow)
text_area_grey = label.Label(terminalio.FONT, text="GREY", color=0x808080, x=0, y=36)
text_group_right.append(text_area_grey)
splash.append(text_group_right)


while True:
    pass
